/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamusic.common.item;

import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import org.jetbrains.annotations.NotNull;
import xerca.xercamusic.client.ClientStuff;
import xerca.xercamusic.common.Mod;
import xerca.xercamusic.common.block.BlockMusicBox;
import xerca.xercamusic.common.block.Blocks;
import xerca.xercamusic.common.item.IItemInstrument;
import xerca.xercamusic.common.item.Items;
import xerca.xercamusic.common.packets.clientbound.TripleNoteClientPacket;

public class ItemBlockInstrument
extends class_1747
implements IItemInstrument {
    private ArrayList<IItemInstrument.Pair<Integer, class_3414>> sounds;
    private IItemInstrument.InsSound[] insSounds;
    private final int minOctave;
    private final int maxOctave;
    private final int instrumentId;

    public ItemBlockInstrument(int instrumentId, int minOctave, int maxOctave, class_2248 block) {
        this(instrumentId, minOctave, maxOctave, new class_1792.class_1793(), block);
    }

    public ItemBlockInstrument(int instrumentId, int minOctave, int maxOctave, class_1792.class_1793 properties, class_2248 block) {
        super(block, properties);
        this.instrumentId = instrumentId;
        this.minOctave = minOctave;
        this.maxOctave = maxOctave;
    }

    @Override
    public int getMinOctave() {
        return this.minOctave;
    }

    @Override
    public int getMaxOctave() {
        return this.maxOctave;
    }

    @Override
    public int getInstrumentId() {
        return this.instrumentId;
    }

    @Nonnull
    public class_1271<class_1799> method_7836(@NotNull class_1937 worldIn, class_1657 playerIn, @NotNull class_1268 handIn) {
        class_1799 heldItem = playerIn.method_5998(handIn);
        class_1799 off = playerIn.method_6079();
        if (handIn == class_1268.field_5808 && off.method_7909() == Items.MUSIC_SHEET) {
            if (!worldIn.field_9236) {
                IItemInstrument.playMusic(worldIn, playerIn, true);
            }
        } else if (worldIn.field_9236) {
            Mod.onlyRunOnClient(() -> ClientStuff::showInstrumentGui);
        }
        return new class_1271(class_1269.field_5812, (Object)heldItem);
    }

    @Nonnull
    public class_1269 method_7884(class_1838 context) {
        class_2338 blockpos;
        class_1937 world = context.method_8045();
        class_2680 blockState = world.method_8320(blockpos = context.method_8037());
        if (blockState.method_26204() == Blocks.MUSIC_BOX && !((Boolean)blockState.method_11654((class_2769)BlockMusicBox.HAS_INSTRUMENT)).booleanValue()) {
            class_1799 itemstack = context.method_8041();
            if (!world.field_9236) {
                BlockMusicBox.insertInstrument((class_1936)world, blockpos, blockState, itemstack.method_7909());
                if (context.method_8036() != null && !context.method_8036().method_31549().field_7477) {
                    itemstack.method_7934(1);
                }
            }
            return class_1269.field_5812;
        }
        return super.method_7884(context);
    }

    public boolean method_7873(@NotNull class_1799 stack, @NotNull class_1309 target, class_1309 attacker) {
        class_1937 world = attacker.method_37908();
        if (!world.field_9236) {
            int note1 = 21 + this.minOctave * 12 + world.field_9229.method_43048((this.maxOctave + 1) * 12 - this.minOctave * 12);
            int note2 = 21 + this.minOctave * 12 + world.field_9229.method_43048((this.maxOctave + 1) * 12 - this.minOctave * 12);
            int note3 = 21 + this.minOctave * 12 + world.field_9229.method_43048((this.maxOctave + 1) * 12 - this.minOctave * 12);
            Collection players = PlayerLookup.around((class_3218)((class_3218)target.method_37908()), (class_243)target.method_19538(), (double)24.0);
            TripleNoteClientPacket packet = new TripleNoteClientPacket(note1, note2, note3, this, (class_1297)target);
            for (class_3222 player : players) {
                Mod.sendToClient(player, packet);
            }
        }
        return true;
    }

    @Override
    public void setSounds(ArrayList<IItemInstrument.Pair<Integer, class_3414>> sounds) {
        this.sounds = sounds;
        this.insSounds = new IItemInstrument.InsSound[96];
        for (int i = 0; i < 96; ++i) {
            int octave;
            int note = IItemInstrument.idToNote(i);
            int index = this.getClosest(note);
            if (index < 0 || index >= sounds.size()) {
                Mod.LOGGER.error("Invalid sound index in Instrument construction");
            }
            if ((octave = i / 12) < this.minOctave || octave > this.maxOctave) continue;
            float pitch = (float)Math.pow(1.05946314465679, note - sounds.get(index).first());
            this.insSounds[i] = new IItemInstrument.InsSound(sounds.get(index).second(), pitch);
        }
    }

    private int getClosest(int note) {
        int minDiff = 100;
        int bestIndex = -1;
        for (int i = 0; i < this.sounds.size(); ++i) {
            int diff = Math.abs(this.sounds.get(i).first() - note);
            if (diff >= minDiff) continue;
            minDiff = diff;
            bestIndex = i;
        }
        return bestIndex;
    }

    @Override
    @Nullable
    public IItemInstrument.InsSound getSound(int note) {
        int id = IItemInstrument.noteToId(note);
        if (id >= 0 && id < 96) {
            return this.insSounds[id];
        }
        Mod.LOGGER.warn("Requested invalid note from Instrument getSound: {}", (Object)note);
        return null;
    }
}

